#ifndef SPRITES_
#define SPRITES_
#define IOWR_VGA_DATA(base,offset,data) IOWR_32DIRECT(base,offset*4,data)
#define BLUE_ARROW 11
#define RED_ARROW 21
#define BLUE_RETICLE 12
#define RED_RETICLE 22
#define PROJECTILE 20
#define ARROW_OFFSET 30
#define LEFT 0
#define RIGHT 1
#define WALK_DISTANCE 2
#define G .8
#define BAZOOKA 0
#define BAT 1
#define RETICLE_OFFSET 30

struct spriteStruct{
    int shown;
    int h;
    int v;
    int spriteNumber;
    int flip;    
};

void updateSprites(struct spriteStruct *s)
{
int i;
int spriteID = 0;
int shown = 0;
int h = 0;
int v = 0;
int spriteNumber = 0;
int spriteFlip = 0;

unsigned int c;

for(i = 0; i < 16; i++)
{            
            
            spriteID = i;
            shown = (*(s + i)).shown;
            h = (*(s + i)).h;
            v = (*(s + i)).v;
            spriteNumber = (*(s + i)).spriteNumber;
            spriteFlip = (*(s + i)).flip;
            
            spriteID <<= 27;
            shown <<= 26;
            h <<= 16;
            v <<= 6;
            spriteNumber <<= 1; // between 0 and 30
       
            c = (spriteID|shown|h|v|spriteNumber|spriteFlip);
        
            IOWR_VGA_DATA(VGA_BASE,2,c); 
}
}

void initializeWorms(struct spriteStruct *s, float *terrain)
{

IOWR_VGA_DATA(VGA_BASE,3,0); 

int i;

for(i = 0; i < 4; i++)
{
  (*(s + i)).shown = 1;
  (*(s + i)).flip = LEFT;
  (*(s + i)).h = 20 + (int)((GAMEBOARD_LENGTH - 40)*getRandom());
  (*(s + i)).v = (int)(GAMEBOARD_HEIGHT-*(terrain + (*(s + i)).h + 16) - 23);  
}    
    
}

void sitWorms(struct spriteStruct *s, float *terrain)
{
int i;

for(i = 0; i < 4; i++)
{
  (*(s + i)).v = (int)(GAMEBOARD_HEIGHT-*(terrain + (*(s + i)).h + 16) - 23);  
}       
}

void placeReticle(struct spriteStruct *s, int wormsTurn, float angle, float pow)
{
  (*(s + 8)).shown = 1;
  (*(s + 8)).flip = 0;
  if(wormsTurn == 0 || wormsTurn == 2) {(*(s + 8)).spriteNumber = BLUE_RETICLE;}
  if(wormsTurn == 1 || wormsTurn == 3) {(*(s + 8)).spriteNumber = RED_RETICLE;}
  
  (*(s + 8)).v = (*(s + wormsTurn)).v + (int)((pow)*sin(angle));
  
  
  if((*(s + wormsTurn)).flip) {(*(s + 8)).h = (*(s + wormsTurn)).h + (int)((pow)*cos(angle));}
  else {(*(s + 8)).h = (*(s + wormsTurn)).h - (int)((pow)*cos(angle));} 
}

void placeArrows(struct spriteStruct *s, int wormsTurn, int *wormHealth, int *arrowBounce)
{
//Update Animation 
 *arrowBounce -= 2;
 if(*arrowBounce == 0) {*arrowBounce = 30;}
 
int i = 0;
for(i = 0; i < 4; i++)
{
 if(*(wormHealth + i) > 0){(*(s + i + 4)).shown = 1;}
 else {(*(s + i + 4)).shown = 0;}
 (*(s + i + 4)).flip = 0;
}
  
  (*(s + 4)).spriteNumber = BLUE_ARROW;
  (*(s + 5)).spriteNumber = RED_ARROW;
  (*(s + 6)).spriteNumber = BLUE_ARROW;
  (*(s + 7)).spriteNumber = RED_ARROW;
  
  (*(s + 4)).h = (*(s + 0)).h;
  (*(s + 5)).h = (*(s + 1)).h;
  (*(s + 6)).h = (*(s + 2)).h;
  (*(s + 7)).h = (*(s + 3)).h;
  
  (*(s + 4)).v = (*(s + 0)).v - *(wormHealth + 0)/2;
  (*(s + 5)).v = (*(s + 1)).v - *(wormHealth + 1)/2;
  (*(s + 6)).v = (*(s + 2)).v - *(wormHealth + 2)/2;
  (*(s + 7)).v = (*(s + 3)).v - *(wormHealth + 3)/2;   
    
  (*(s + wormsTurn + 4)).v = (*(s + wormsTurn)).v - *(wormHealth + wormsTurn)/2 - *arrowBounce;
   
    //Carlos' code
    unsigned int he; 
    unsigned int ve; 
    unsigned int HeVe;
    //set point 1
    he = (*(s+wormsTurn)).h - Hcoor;
    ve = (*(s+wormsTurn)).v - Vcoor + 16;
    he <<= 22;
    ve <<= 12;
            
    HeVe =  (he|ve);
    IOWR_VGA_DATA(VGA_BASE,5,HeVe); 
    //set point 2
    he = (*(s+wormsTurn)).h - Hcoor + 32;
    ve = (*(s+wormsTurn)).v - Vcoor + 16;
    he <<= 22;
    ve <<= 12;
            
    HeVe =  (he|ve);
    IOWR_VGA_DATA(VGA_BASE,6,HeVe); 
    //end of Carlos'  
}

void animBreath(struct spriteStruct *s, int *breath)
{
int i = 0;

for(i = 0; i < 4; i++)
{
    (*(breath + i))++;
    if (*(breath + i) == 20) {*(breath + i) = 13;}    
    (*(s + i)).spriteNumber = *(breath + i);  
}   
}

void animSwing(struct spriteStruct *s, int wormsTurn, int *swing)
{
(*(swing))++;
(*(s + wormsTurn)).spriteNumber = *swing;
}

void animWalk(struct spriteStruct *s, float *terrain, int wormsTurn, int *walk)
{
    // Update animation variable for walking
    (*walk)++;
    
    // Update sprite 
    (*(s + wormsTurn)).spriteNumber = 23 + *walk;
    
    // Update horizontal position
    if((*(s + wormsTurn)).flip == RIGHT)
    {
        if((*(s + wormsTurn)).h < GAMEBOARD_LENGTH - 60) 
            {
                (*(s + wormsTurn)).h = (*(s + wormsTurn)).h + WALK_DISTANCE;
                (*(s + wormsTurn)).v = (int)(GAMEBOARD_HEIGHT-*(terrain + (*(s + wormsTurn)).h + 16) - 23); 
            }
    }
    else
    {
        if((*(s + wormsTurn)).h > 10) 
        {   
            (*(s + wormsTurn)).h = (*(s + wormsTurn)).h - WALK_DISTANCE;
            (*(s + wormsTurn)).v = (int)(GAMEBOARD_HEIGHT-*(terrain + (*(s + wormsTurn)).h + 16) - 23); 
        }  
    }
} 

int animProjectile(struct spriteStruct *s, float *terrain, int wormsTurn, int *projAnim, float angle, float power, float *vx, float *vy)   
{
(*(s + 9)).spriteNumber = PROJECTILE;  
(*(s + 9)).shown = 1;
(*(s + 9)).flip = 0;

if(*projAnim == 0)
{
    (*(s + 9)).h = (int)(*(s + wormsTurn)).h;
    (*(s + 9)).v = (int)(*(s + wormsTurn)).v; 
    
    if((*(s+wormsTurn)).flip == RIGHT) {*vx = power*cos(angle);}
    if((*(s+wormsTurn)).flip == LEFT) {*vx = -power*cos(angle);}
    *vy = power*sin(angle); 
}
else
{
    *vy = *vy + G;
    if(((*(s + 9)).h < 1) ||((*(s + 9)).h > 1008)) {*vx = -(*vx);} 
    (*(s + 9)).h = (*(s + 9)).h + (int)(*vx);
    (*(s + 9)).v = (*(s + 9)).v + (int)(*vy);    
}

// Increment the animation variable
(*projAnim)++;

// Return the collision coordinate
if((*(s + 9)).v < (GAMEBOARD_HEIGHT-*(terrain + (*(s + 9)).h + 16) - 16)) {return -1;}
else {return (*(s + 9)).h + 16;}  
}  

//Similar to the animProjectile, but it uses the hitWorm as the sprite
int animFlyingWorm(struct spriteStruct *s, float *terrain, int hitWorm, int wormsTurn, int *projAnim, float angle, float power, float *vx, float *vy)   
{
if(*projAnim == 0)
{    
    if((*(s+wormsTurn)).flip == RIGHT) {*vx = power*cos(angle);}
    if((*(s+wormsTurn)).flip == LEFT) {*vx = -power*cos(angle);}
    *vy = power*sin(angle); 
}
else
{
    *vy = *vy + G;
    if(((*(s + hitWorm)).h < 1) ||((*(s + hitWorm)).h > 1008)) {*vx = -(*vx);} 
    (*(s + hitWorm)).h = (*(s + hitWorm)).h + (int)(*vx);
    (*(s + hitWorm)).v = (*(s + hitWorm)).v + (int)(*vy);   
    // Flip the worm back and forth during flight
    if((*(s + hitWorm)).flip == LEFT) { (*(s + hitWorm)).flip = RIGHT;}
    else if ((*(s + hitWorm)).flip == RIGHT) { (*(s + hitWorm)).flip = LEFT;}
}

// Increment the animation variable
(*projAnim)++;

// Return the collision coordinate
if((*(s + hitWorm)).v < (GAMEBOARD_HEIGHT-*(terrain + (*(s + hitWorm)).h + 16)-22)) {return -1;}
else {return (*(s + hitWorm)).h + 16;}  
}  

void drawWeapon(struct spriteStruct *s, int wormsTurn, float angle, int weapon)
{
if(weapon == BAZOOKA)
{
if(angle < -60)                      {(*(s + wormsTurn)).spriteNumber = 10;}
if((angle >= -60) && (angle < -30))  {(*(s + wormsTurn)).spriteNumber = 9;}
if((angle >= -30) && (angle < 30))   {(*(s + wormsTurn)).spriteNumber = 8;}
if((angle >= 30) && (angle < 60))    {(*(s + wormsTurn)).spriteNumber = 7;}   
if(angle >= 60)                      {(*(s + wormsTurn)).spriteNumber = 6;}    
}

if(weapon == BAT) {(*(s + wormsTurn)).spriteNumber = 0;}

}

void drawPOW(struct spriteStruct *s, int hitWorm, int *powAnim)
{
 (*powAnim)++;
 //if(*(powAnim) == 30) {powAnim = 0;}
 (*(s + 10)).spriteNumber = 31; 
 (*(s + 10)).shown = 1;
 (*(s + 10)).h = (*(s + 9)).h;
 (*(s + 10)).v = (*(s + 9)).v - *powAnim;
} 


#endif /*SPRITES_*/
